/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

// inspired from  aiekick/Shane textured variant of https://www.shadertoy.com/view/ls3XWM
//                                      see https://www.shadertoy.com/view/ld3SRB#

void mainImage( out vec4 O, vec2 U ){

	vec2 R = iResolution.xy; R = 4.*floor(R/4.);
    U = (U+U-R)/R.y;                                                 // normalized screen
    float s=floor(++U.x); U.x = mod(U.x+1.+.15*sign(s-.5), 2.) - 1.; // 2 normalized areas
    float r=length(U), a = atan(U.y, U.x), A, B, d, t=iGlobalTime;   // polar coordinates

    O = vec4(0.0,0.0,0.0,1.0);  
   
    for (int i=0; i<3; i++ ) { 
        A = B = 5./3.*a;  if(s>0.) B+=t; else A+=t; // fractional => 3 turns to close loop via 5 wings.
        d = smoothstep(1., .9, 8.*abs(r-.2*sin(A)-.5));                  // ribbon wings
        vec3 T = 1.3*texture2D(iChannel0, vec2(B/3.14159, r-.2*sin(A))).rgb; // to attach texture replace B by A
        O.rgb = max(O.rgb, (1.+cos(A)*.7)/1.7 * d*T);       // 1+cos(A) = depth-shading
        a += 6.28319;                               // next turn
    }
   
   if ( length(O.rgb) < 0.001 ) O.a = 0.0;

}

void main ( void ) 
 { mainImage ( gl_FragColor, gl_FragCoord.xy );
 }